unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,
  UMComboBoxMce;

type
  TMainForm = class(TForm)
    Label1: TLabel;
    cb1: TComboBox;
    Label2: TLabel;
    procedure FormShow(Sender: TObject);
    procedure cb1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure cb1KeyPress(Sender: TObject; var Key: Char);

  private

  public
    cb2 : MComboBoxMce;
      
    procedure Wypelnij_i_ustaw_cb();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.Wypelnij_i_ustaw_cb();
var
   Year, Month, Day : Word;

   mc         : Integer;
   dzisiaj    : TDate;
   poz        : Integer;
   seekmc     : Integer;
   txt        : String;


begin
   mc      := 0;
   dzisiaj := Date();
   poz     := 0;
   seekmc  := 0;
   txt     := '';

   cb1.Clear();
   cb1.Width := 45;
   
   for mc := 1 to 12 do
   begin
      cb1.Items.Add(IntToStr(mc));
   end;

   dzisiaj := Date();
   DecodeDate(dzisiaj, Year, Month, Day);
   seekmc  := Month;
   txt     := IntToStr(seekmc);

	cb1.ItemIndex := -1;
   poz := cb1.Items.IndexOf(txt);
   if poz > -1 then
   begin
      cb1.ItemIndex := poz;
   end;
end;

procedure TMainForm.cb1KeyPress(Sender: TObject; var Key: Char);
begin
   if (Key = CHR(VK_DOWN)) or (Key = CHR(VK_UP)) then
   begin
      // OK
   end
   else begin
      Key := CHR(0);
   end;
end;

procedure TMainForm.cb1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if (Key = VK_DOWN) or (Key = VK_UP) then
   begin
		// OK
   end
   else begin
      Key := 0;
   end;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
	// ustawia cb1
	Wypelnij_i_ustaw_cb();

   // tworzy i ustawia cb2
	cb2        := MComboBoxMce.Create(Self);
   cb2.Parent := MainForm;
   cb2.Top    := cb1.Top + cb1.Height + 5;
   cb2.Left   := cb1.Left;
end;

end.
